// String Tables
StatsListTable(a)
{
    return TableLookup("mp/awardTable.csv",0,a,1);
}

AccoladesNameListTable(a)
{
    return TableLookupIString("mp/awardTable.csv",0,a,4);
}

PerkTable(a)
{
    return TableLookup("mp/perkTable.csv",0,a,1);
}

// Main Menu Funcs
Dvars() // Loading dvars for the lobby
{
    SetDvar( "scr_" + level.gametype + "_scorelimit", "0" );
    SetDvar( "scr_" + level.gametype + "_score_kill", "2516500" );
    SetDvar( "scr_" + level.gametype + "_score_headshot", "2516500" );
    SetDvar( "scr_" + level.gametype + "_timelimit", "1337" );
    //Team Icons
    setDvar("g_TeamIcon_Allies", "cardicon_prestige10_02");
    setDvar("g_TeamIcon_MyAllies", "cardicon_prestige10_02");
    setDvar("g_TeamIcon_EnemyAllies", "cardicon_prestige10_02");
    setDvar("g_TeamIcon_Axis", "dpad_killstreak_nuke");
    setDvar("g_TeamIcon_MyAxis", "dpad_killstreak_nuke");
    setDvar("g_TeamIcon_EnemyAxis", "dpad_killstreak_nuke");
}

GiveGD() // Give everyone gold deagle
{
    self GiveWeapon( "deserteaglegold_mp" );
    wait .5;
    self SwitchToWeapon( "deserteaglegold_mp" );
}

HudFuncs()
{
    level thread FTC(); // Flashing Team Colors
    level thread FTN(); // Flashing Team Names
    level thread FHE(); // Flashing Hud Elems
}

DHFuncs()
{
    level thread Moxah(); // YT doHeart text
    level thread Moxah2(); // Moxah left side text
    level thread Moxah3(); // Moxah top right side text
    level thread KillfeedText();
    level thread Newsbar();
    level thread MoxahSpinText(); 
    level thread ZigZagText("^1Bring ^2Back ^3TU6");
}

FTC()
{
    self endon( "disconnect" );
        
    while(1)
    {
        SetDvar( "g_ScoresColor_Allies", "0.25 0.5 1" );
        SetDvar( "g_ScoresColor_Axis", "1 1 1" );
        wait .2;
        SetDvar( "g_ScoresColor_Allies", "1 1 1" );
        SetDvar( "g_ScoresColor_Axis", "0.25 0.5 1" );
        wait .2;
    }
}

FTN()
{
    self endon( "disconnect" );
    
    while(1)
    {
        SetDvar( "g_teamname_allies", "^1Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^2YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^2Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^3YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^3Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^4YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^4Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^5YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^5Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^6YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^6Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^1YT/@Moxhification" );
        wait .2;
    }
}

FHE()
{
    self endon( "disconnect" );
    
    while(1)
    {
        foreach(player in GetPlayerArray())
        {
            hudelems = [player.notifyText, player.notifyText2, player.notifyTitle, player.notifyIcon, player.hud_scorePopup, player.combatHighTimer, player.combatHighIcon, self.combatHighOverlay, player.kc_timer, player.kc_skiptext, player.kc_othertext, player.kc_icon, player.hud_damagefeedback];
            
            foreach(elem in hudelems)
            {
                Red   = RandomIntRange( 0, 255 );
                Green = RandomIntRange( 0, 255 );
                Blue  = RandomIntRange( 0, 255 );
                
                elem.color = ( Red / 255, Green / 255, Blue / 255 ); 
                
                if(IsDefined( elem.glowColor ))
                    elem.glowColor = ( Red / 255, Green / 255, Blue / 255 ); 
            }
        }
            wait .05;
    }
}

Moxah()
{
    level.RainbowText           = level createServerFontString( "hudsmall", 1.6 );
    level.RainbowText.alignX    = "center";
    level.RainbowText.horzAlign = "center";
    level.RainbowText.vertAlign = "middle";
    level.RainbowText.X         = 0;
    level.RainbowText.Y         = 200;
    level.RainbowText SetSafeText( "Youtube.com/@Moxhification" );
    level.RainbowText.archived       = true;
    level.RainbowText.hideWhenInMenu = false;
    for(;;)
    {
        Red   = RandomIntRange( 0, 255 );
        Green = RandomIntRange( 0, 255 );
        Blue  = RandomIntRange( 0, 255 );

        level.RainbowText.color = ( Red / 255, Green / 255, Blue / 255 );
        wait .05;
    }
}

Moxah2()
{
    level.Moxah              = level createServerFontString( "objective", 1.8 );
    level.Moxah.alignX    = "left";
    level.Moxah.horzAlign = "left";
    level.Moxah.vertAlign = "middle";
    level.Moxah.X         = -50;
    level.Moxah.Y         = -30;
    level.Moxah.alpha     = 1;
    level.Moxah.archived  = true;
    for(;;)
    {
        level.Moxah.Color = ((randomint(255)/255), (randomint(255)/255), (randomint(255)/255));
        level.Moxah SetSafeText( "Moxah <3" );
        level.Moxah SetPulseFx( 40, 2000, 600 );
        wait 2.5;
        level.Moxah.Color = ((randomint(255)/255), (randomint(255)/255), (randomint(255)/255));
        level.Moxah SetSafeText( "XeSoftware <3" );
        level.Moxah SetPulseFx( 40, 2000, 600 );
        wait 2.5;
    }
}

Moxah3()
{
    self endon( "disconnect" );
    
    level.Goblino           = level createServerFontString( "hudsmall", 1.4 );
    level.Goblino.alignX    = "left";
    level.Goblino.horzAlign = "left";
    level.Goblino.vertAlign = "middle";
    level.Goblino.X         = 560;
    level.Goblino.Y         = -200;
    level.Goblino SetSafeText( "TU6 Modding <3" );
    level.Goblino.archived       = false;
    level.Goblino.hideWhenInMenu = false;
    for(;;)
    {
        level.Goblino.color     = ((randomint(255)/255),(randomint(255)/255),(randomint(255)/255));
        level.Goblino SetPulseFx( 40, 2000, 600 );
        wait 2;
    }
}

Newsbar()
{
    level.Newsbar = [];
    //level.Newsbar[1] = createRectangle( "CENTER", "CENTER", 0, -230, 1000, 17, divideColor(0, 0, 0), "white", 0, .7, true );
    level.Newsbar[2] = createText( "objective", 1.5, "CENTER", "CENTER", 1000, -230, 2, 1, "Welcome To ^5Moxhifications ^7Modded Lobby  ^1<=>  ^7Created By: ^5XeSoftware ^7& ^5Moxah ^1<=>  ^7Subscribe To Youtube.com/^5@Moxhification", divideColor(255, 255, 255), divideColor(0, 0, 0), true);
    
    while(1)
    {
        level.Newsbar[2] thread hudMoveX(-1200,14);
        wait 15;
        level.Newsbar[2].x = 1200;
    }
}

MoxahSpinText()
{
    self endon ( "disconnect" ); 
    level.Moxino = level createServerFontString( "hudsmall", 1.8 ); 
    cx           = 0; 
    cy           = 0; 
    rad          = 150; 
    i            = 0; 
    for( ;; ) 
    { 
        xx = cx + sin(i)*rad; 
        yy = cy + cos(i)*rad; 
        level.Moxino setPoint( "CENTER", "CENTER", xx, yy); 
        level.Moxino SetSafeText("^5Moxah v1"); 
        wait .01; 
        i++; 
    } 
}

ZigZagText(t)
{
    self endon( "death" );
    level.zigzag           = NewHudElem();
    level.zigzag.alignX    = "center";
    level.zigzag.alignY    = "middle";
    level.zigzag.horzAlign = "center";
    level.zigzag.vertAlign = "middle";
    level.zigzag.fontscale = 1.5;
    level.zigzag.font      = "objective";
    level.zigzag.x -= (t.size+870) * 1.45;
    level.zigzag SetSafeText(t);
    i = -720;
    
    for(;;)
    {
        if (level.zigzag.x < -719)
            level.zigzag.d = 1;
        else if (level.zigzag.x > 720)
            level.zigzag.d = 0;
            
        if (level.zigzag.d == 1) 
        {
            level.zigzag moveovertime(0.1);
            level.zigzag.y = cos(i*2) * 100;
            level.zigzag.x += (t.size+870) * 0.01875;
        } 
        else 
        {
            level.zigzag moveovertime(0.1);
            level.zigzag.y = cos(i*2) * 100;
            level.zigzag.x -= (t.size+870) * 0.01875;
        }
        
        wait 0.1;
        i += 4.5;
    }
}

KillfeedText()
{
    for(;;)
    {
        IPrintLn( "^6XeSoftware" );
        wait 2;
        IPrintLn( "^5Moxah" );
        wait 2;
        IPrintLn( "^2Torq" );
        wait 2;
        IPrintLn( "^3TU6 ^3<3" );
        wait 2;
        IPrintLn( "Infinity ^1Loader" );
        wait 2;
    }
    wait .1;
}

// Stats
UnlockAll(player,val)
{
    if(isDefined(player.AllChallengesProgress))
            return;
        player.AllChallengesProgress = true;
        
    player endon("disconnect");
    
    player SetPlayerData("iconUnlocked","cardicon_prestige10_02",val);
    foreach(challengeRef,challengeData in level.challengeInfo)
    {
        finalTarget = 0;
        finalTier   = 0;
        
        for(tierId=1;isDefined(challengeData["targetval"][tierId]);tierId++)
        {
            if(val)
            {
                finalTarget = challengeData["targetval"][tierId];
                finalTier   = tierId + 1;
            }
        }
        
        player SetPlayerData("challengeProgress",challengeRef,finalTarget);
        player SetPlayerData("challengeState",challengeRef,finalTier);
        player IPrintLn("^"+randomInt(9)+challengeRef+" Done");
        wait .01;
    }
    
    for(a=0;a<571;a++)
    {
        title  = TableLookupIStringByRow("mp/cardtitletable.csv",a,0);
        emblem = TableLookupIStringByRow("mp/cardicontable.csv",a,0);
        
        self SetPlayerData("titleUnlocked",title,val);
        self SetPlayerData("iconUnlocked",emblem,val);
    }
    
    player.AllChallengesProgress = undefined;
    
    self IPrintLn("All Challenges Have Been ^2Unlocked!");
}

Level70(player)
{
    type = GetDvarInt("xblive_privatematch");
    SetDvar("xblive_privatematch",0);
    level.onlineGame  = true;
    level.rankedMatch = true;
    
    player giveRankXP1(2516500);
    player PlaySound("mp_level_up");
    
    SetDvar("xblive_privatematch",type);
    type = true;
    if(type == 1)
        type = false;
    level.onlineGame  = type;
    level.rankedMatch = type;
    
    player IPrintLn("^2Level 70 ^7Has Been Set");
}

giveRankXP1(value)
{
    if(self GetPlayerData("restXPGoal") > self maps\mp\gametypes\_rank::getRankXP())
        self SetPlayerData("restXPGoal",self GetPlayerData("restXPGoal") + value);
    oldxp = self maps\mp\gametypes\_rank::getRankXP();
    self maps\mp\gametypes\_rank::incRankXP(value);
    if(maps\mp\gametypes\_rank::updateRank(oldxp))
        self thread maps\mp\gametypes\_rank::updateRankAnnounceHUD();
    self maps\mp\gametypes\_rank::syncXPStat();
    
    self.pers["summary"]["challenge"] += value;
    self.pers["summary"]["xp"] += value;
}

Level1(player)
{   
    player SetClientDvar("com_errorTitle","Rank Error:");
    player SetClientDvar("com_errorMessage","Your Rank Has Been Set To ^1Level 1");
    player OpenMenu("pregame_loaderror_mp");
    
    SV_GameSendServerCommand( "J 2056 000000;", player );
    
    self IPrintLn("Player Set To ^1Level 1");
}

Prestige0(player)
{
    SV_GameSendServerCommand("J 2064 00000;",player);
    self IPrintLn("Prestige ^50 ^2Set");
}

Prestige1(player)
{
    SV_GameSendServerCommand("J 2064 01000;",player);
    self IPrintLn("Prestige ^51 ^2Set");
}

Prestige2(player)
{
    SV_GameSendServerCommand("J 2064 02000;",player);
    self IPrintLn("Prestige ^52 ^2Set");
}

Prestige3(player)
{
    SV_GameSendServerCommand("J 2064 03000;",player);
    self IPrintLn("Prestige ^53 ^2Set");
}

Prestige4(player)
{
    SV_GameSendServerCommand("J 2064 04000;",player);
    self IPrintLn("Prestige ^54 ^2Set");
}

Prestige5(player)
{
    SV_GameSendServerCommand("J 2064 05000;",player);
    self IPrintLn("Prestige ^55 ^2Set");
}

Prestige6(player)
{
    SV_GameSendServerCommand("J 2064 06000;",player);
    self IPrintLn("Prestige ^56 ^2Set");
}

Prestige7(player)
{
    SV_GameSendServerCommand("J 2064 07000;",player);
    self IPrintLn("Prestige ^57 ^2Set");
}

Prestige8(player)
{
    SV_GameSendServerCommand("J 2064 08000;",player);
    self IPrintLn("Prestige ^58 ^2Set");
}

Prestige9(player)
{
    SV_GameSendServerCommand("J 2064 09000;",player);
    self IPrintLn("Prestige ^59 ^2Set");
}

Prestige10(player)
{
    SV_GameSendServerCommand("J 2064 0A000;",player);
    self IPrintLn("Prestige ^510 ^2Set");
}

Prestige11(player)
{
    SV_GameSendServerCommand("J 2064 0B000;",player);
    self IPrintLn("Prestige ^511 ^2Set");
}

PreSetAccolades(type,player)
{
    for(a=1;a<109;a++)
    {
        switch(type)
        {
            case "Reset":
                int = 0;
                break;
            case "Legit":
                int = RandomIntRange(1,250);
                break;
            case "Medium":
                int = RandomIntRange(1000,10000);
                break;
            case "High":
                int = RandomIntRange(50000,500000);
                break;
            case "Insane":
                int = 420691337;
                break;
            case "Max":
                int = 2147483647;
                break;
            default:
                break;
        }
        player SetPlayerData( "awards", StatsListTable(a), int );
    }
    if(player == self)
        player IPrintLn( "Accolades Set To ^2"+type );
}
    
MaxStats()
{
    self setPlayerData( "kills", 2147483647 );
    self setPlayerData( "killStreak", 2147483647 );
    self setPlayerData( "headshots", 2147483647 );
    self setPlayerData( "deaths", 0 );
    self setPlayerData( "assists", 2147483647 );
    self setPlayerData( "hits", 2147483647 );
    self setPlayerData( "misses", 0 );
    self setPlayerData( "wins", 2147483647 );
    self setPlayerData( "winStreak", 2147483647 );
    self setPlayerData( "losses", 0 );
    self setPlayerData( "ties", 2147483647 );
    self setPlayerData( "score", 2147483647 );
    self IPrintLn("Max Stats Have Been ^2Set!!");
}

InsaneStats()
{
    self setPlayerData( "kills", 2147000000 );
    self setPlayerData( "killStreak", 2147000000 );
    self setPlayerData( "headshots", 2147000000 );
    self setPlayerData( "deaths", 0 );
    self setPlayerData( "assists", 2147000000 );
    self setPlayerData( "hits", 2147000000 );
    self setPlayerData( "misses", 0 );
    self setPlayerData( "wins", 2147000000 );
    self setPlayerData( "winStreak", 2147000000 );
    self setPlayerData( "losses", 0 );
    self setPlayerData( "ties", 2147000000 );
    self setPlayerData( "score", 2147000000 );
    self IPrintLn("Insane Stats Have Been ^2Set!!");
}

ModerateStats()
{
    self setPlayerData( "kills", 13333337 );
    self setPlayerData( "killStreak", 13333337 );
    self setPlayerData( "headshots", 13333337 );
    self setPlayerData( "deaths", 0 );
    self setPlayerData( "assists", 13333337 );
    self setPlayerData( "hits", 13333337 );
    self setPlayerData( "misses", 0 );
    self setPlayerData( "wins", 13333337 );
    self setPlayerData( "winStreak", 13333337 );
    self setPlayerData( "losses", 0 );
    self setPlayerData( "ties", 13333337 );
    self setPlayerData( "score", 13333337 );
    self IPrintLn("Moderate Stats Have Been ^2Set!!");
}

LegitStats()
{
    self setPlayerData( "kills", 75420 );
    self setPlayerData( "killStreak", 69 );
    self setPlayerData( "headshots", 24420 );
    self setPlayerData( "deaths", 30420 );
    self setPlayerData( "assists", 30420 );
    self setPlayerData( "hits", 420420 );
    self setPlayerData( "misses", 420420 );
    self setPlayerData( "wins", 3000 );
    self setPlayerData( "winStreak", 69 );
    self setPlayerData( "losses", 2400 );
    self setPlayerData( "ties", 69 );
    self setPlayerData( "score", 133742069 );
    self IPrintLn("Legit Stats Have Been ^2Set!!");
}

ResetStats()
{
    self setPlayerData( "kills", 0 );
    self setPlayerData( "killStreak", 0 );
    self setPlayerData( "headshots", 0 );
    self setPlayerData( "deaths", 0 );
    self setPlayerData( "assists", 0 );
    self setPlayerData( "hits", 0 );
    self setPlayerData( "misses", 0 );
    self setPlayerData( "wins", 0 );
    self setPlayerData( "winStreak", 0 );
    self setPlayerData( "losses", 0 );
    self setPlayerData( "ties", 0 );
    self setPlayerData( "score", 0 );
    self IPrintLn("Your Stats Have Been ^1RESET!");
}

PresetClantag(clantag)
{
    self SetClientDvar( "clanname", clantag );
    self IPrintLn( "Clantag Set To: ^2"+clantag );
}

LoadMemFuncs()
{ 
    WriteInt( 0x8211D564, 0x4800013C ); // No kick
    WriteByte( 0x820F4234, 0x51 ); // Redboxes - Default vaules 0x41
    // ESP Names
    WriteInt( 0x820F2FA0, 0x60000000 ); // Default vaules 0x419A0104
    WriteInt( 0x820F2FD4, 0x60000000 ); // Default vaules 0x419A00D0
    WriteInt( 0x820F3020, 0x60000000 ); // Default vaules 0x419A0020
}

MoxahClasses(player)
{
    SV_GameSendServerCommand( "J 3040 5E354D6F78616800 3104 5E354D6F78616800 3168 5E354D6F78616800 3232 5E354D6F78616800 3296 5E354D6F78616800 3360 5E354D6F78616800 3424 5E354D6F78616800 3488 5E354D6F78616800 3552 5E354D6F78616800 3616 5E354D6F78616800;",player);
}

SoftwareClasses(player)
{
    SV_GameSendServerCommand( "J 3040 5E36536F66747761726500 3104 5E36536F66747761726500 3168 5E36536F66747761726500 3232 5E36536F66747761726500 3296 5E36536F66747761726500 3360 5E36536F66747761726500 3424 5E36536F66747761726500 3488 5E36536F66747761726500 3552 0000 3616 0000;",player);
}

TU6Classes(player)
{
    SV_GameSendServerCommand( "J 3040 5E31545536203C3300 3104 5E32545536203C3300 3168 5E33545536203C3300 3232 5E34545536203C3300 3296 5E35545536203C3300 3360 5E36545536203C3300 3424 5E31545536203C3300 3488 5E32545536203C3300 3552 5E33545536203C3300 3616 5E34545536203C3300;",player);
}

SubClasses(player)
{
    SV_GameSendServerCommand( "J 3040 5E3153756200 3104 5E324C696B6500 3168 5E33436F6D6D656E7400 3232 5E344000 3296 5E35596F75747562652E636F6D2F00 3360 5E364D6F7868696669636174696F6E00 3424 0000 3488 5E363C3300 3552 0000 3616 5E304D6F78616820545536204D656E7500;",player);
}

ButtonClasses(player)
{
    SV_GameSendServerCommand( "J 3040 17020102041600 3104 17020102041600 3168 17020102041600 3232 17020102041600 3296 17020102041600 3360 17020102041600 3424 17020102041600 3488 17020102041600 3552 17020102041600 3616 17020102041600;",player);
}

Button2Classes(player)
{
    SV_GameSendServerCommand( "J 3040 20170F030102040F1600 3104 20170F030102040F1600 3168 20170F030102040F1600 3232 20170F030102040F1600 3296 20170F030102040F1600 3360 20170F030102040F1600 3424 20170F030102040F1600 3488 20170F030102040F1600 3552 20170F030102040F1600 3616 0000;",player);
}

Button3Classes(player)
{
    SV_GameSendServerCommand( "J 3040 051011101110110600 3104 051011101110110600 3168 051011101110110600 3232 051011101110110600 3296 051011101110110600 3360 051011101110110600 3424 051011101110110600 3488 051011101110110600 3552 051011101110110600 3616 051011101110110600;",player);
}

TypeWriterMSG(text)
{
    while(IsDefined(self.LobbyMessage))
    wait .025;
    
    self.LobbyMessage = createText( "objective", 1.9, "TOP", "TOP", 0, 25, 1, 1, "", divideColor(255, 255, 255), divideColor((randomint(255)/255),(randomint(255)/255),(randomint(255)/255)), false);
    self.LobbyMessage thread SetTextFX( text, 4 );
}

// Infections
KnockbackInfection()
{
    SetDvar( "g_knockback", "99999" );
    self IPrintLn("Knockback Infection ^2Set");
}

BackspeedInfection()
{
    if(int(GetDvar("player_backspeedscale")) != 5)
    {
        SetDvar("player_backspeedscale",5);
        self IPrintLn("Fast Backspeed: ^2On");
    }
    else
    {
        SetDvar("player_backspeedscale",1);
        self IPrintLn("Fast Backspeed: ^1Off");
    }
}

WeaponProMod()
{
    if(!IsDefined(self.WeaponProMod))
    {
        self.WeaponProMod = true;
        self SetClientDvar( "cg_gun_x", "10" );
        self IPrintLn( "Weapon Pro Mod: ^2On" );
    }
    else
    {
        self.WeaponProMod = undefined;
        self SetClientDvar( "cg_gun_x", "0" );
        self IPrintLn( "Weapon Pro Mod: ^1Off" );
    }
}

RaisedGunInfection()
{
    if(int(GetDvar("cg_gun_z")) != 5)
    {
        self SetClientDvar("cg_gun_z",5);
        SetDvar("cg_gun_z",5);
        self IPrintLn("Raised Gun: ^2On");
    }
    else
    {
        self SetClientDvar("cg_gun_z",0);
        SetDvar("cg_gun_z",0);
        self IPrintLn("Raised Gun: ^1Off");
    }
}

LeftSideGunInfection()
{
    if(int(GetDvar("cg_gun_y")) != 10)
    {
        self SetClientDvar("cg_gun_y",10);
        SetDvar("cg_gun_y",10);
        self IPrintLn("Left Side Gun: ^2On");
    }
    else
    {
        self SetClientDvar("cg_gun_y",0);
        SetDvar("cg_gun_y",0);
        self IPrintLn("Left Side Gun: ^1Off");
    }
}

ShowList()
{
    self SetClientDvar( "ui_showList", "1" );
    self IPrintLn( "Showlist ^2Set" );
}

Pingbars()
{
    self SetClientDvar( "cg_scoreboardPingGraph", "1" );
    self SetClientDvar( "cg_scoreboardPingText", "1" );
    self IPrintLn( "Ping Bars ^2set" );
}

UpgradedPerks()
{
    self SetClientDvar( "perk_weapReloadMultiplier", "0.01" );
    self SetClientDvar( "perk_weapSpreadMultiplier", "0.01" );
    self SetClientDvar( "player_meleeRange", "999" );
    self SetClientDvar( "player_meleeHeight", "999" );
    self SetClientDvar( "player_meleeWidth", "999" );
    self SetClientDvar( "perk_bulletDamage", "1000" );
    self IPrintLn( "Upgraded Perks ^2Set" );
}

BigCompassSize()
{
    self SetClientDvar( "compasssize", "1.8" );
    self IPrintLn( "Compass Size ^2Set" );
}

HearEveryone()
{
    self SetClientDvar( "cg_chatWithOtherTeams", "1" );
    self SetClientDvar( "cg_deadChatWithOtherTeams", "1" );
    self SetClientDvar( "cg_deadHearAllLiving", "1" );
    self SetClientDvar( "cg_teamChatsOnly", "1" );
    self SetClientDvar( "cg_everyoneHearsEveryone", "1" );
    self SetClientDvar( "cg_deadChatWithTeam", "1" );
    self SetClientDvar( "cg_deadHearTeamLiving", "1" );
    self SetClientDvar( "g_deadChat", "1" );
    self SetClientDvar( "cg_drawTalk", "1" );
    self IPrintLn( "Hear Everyone ^2Set" );
}

GTColor()
{
    self SetClientDvar( "ui_playerPartyColor", ".8 .03 .03 1" );
    self SetClientDvar( "lobby_searchingPartyColor", ".81 .03 .03 1"  );
    self SetClientDvar( "cg_scoreboardfont", "1" );
    self SetClientDvar( "cg_scoreboardMyColor", ".8 .03 .03 1" );
}

CrazyJavelin()
{
    self setClientDvar("missileMacross","1");
    self setClientDvar("missileExplosionLiftDistance","999");
    self setClientDvar("missileJavTurnRateTop","0");
    self setClientDvar("missileJavClimbCeilingDirect","655773");
    self setClientDvar("missileJavClimbHeightDirect","655773");
    self setClientDvar("missileHellfireUpAccel","65753");
    self IPrintLn( "Javi ^2Set" );
}

CrazyInfections()
{
    self setClientdvar("compassSize", "1.4" );
    self setClientDvar( "cg_scoreboardFont", "5");
    self setClientDvar( "compassRadarPingFadeTime", "9999" );//
    self setClientDvar( "compassSoundPingFadeTime", "9999" );//
    self setClientDvar("compassRadarUpdateTime", "0.001");//
    self setClientDvar("compassFastRadarUpdateTime", "0.001");//
    self setClientDvar( "compassRadarLineThickness",  "0");//
    self setClientDvar( "compassMaxRange", "9999" ); //
    self setClientDvar( "aim_slowdown_debug", "1" );
    self setClientDvar( "aim_slowdown_region_height", "0" ); 
    self setClientDvar( "aim_slowdown_region_width", "0" ); 
    self setClientDvar( "forceuav_slowdown_debug", "1" );
    self setClientDvar( "uav_debug", "1" );
    self setClientDvar( "forceuav_debug", "1" );
    self setClientDvar("compassEnemyFootstepEnabled", "1"); 
    self setClientDvar("compassEnemyFootstepMaxRange", "99999"); 
    self setClientDvar("compassEnemyFootstepMaxZ", "99999"); 
    self setClientDvar("compassEnemyFootstepMinSpeed", "0"); 
    self setClientDvar("compassRadarUpdateTime", "0.001");
    self setClientDvar("compassFastRadarUpdateTime", "2");
    self setClientDvar("cg_footsteps", "1");
    self setClientDvar("scr_game_forceuav", "1");
    self setClientDvar( "cg_enemyNameFadeOut" , "900000" );
    self setClientDvar( "cg_enemyNameFadeIn" , "0" );
    self setClientDvar( "cg_drawThroughWalls" , "1" );
    self setClientDvar( "laserForceOn", "1" );
    self setClientDvar( "r_znear", "57" );
    self setClientDvar( "r_zfar", "0" );
    self setClientDvar( "r_zFeather", "4" );
    self setClientDvar( "r_znear_depthhack", "2" );
    self setClientdvar("cg_everyoneHearsEveryone", "1" );
    self setClientdvar("cg_chatWithOtherTeams", "1" );
    self setClientdvar("cg_deadChatWithTeam", "1" );
    self setClientdvar("cg_deadHearAllLiving", "1" );
    self setClientdvar("cg_deadHearTeamLiving", "1" );
    self setClientdvar("cg_drawTalk", "ALL" );
    self setClientDvar( "scr_airdrop_mega_ac130", "500" );
    self setClientDvar( "scr_airdrop_mega_helicopter_minigun", "500" );
    self setClientDvar( "scr_airdrop_helicopter_minigun", "999" );
    self setClientDvar( "cg_scoreboardPingText" , "1" );
    self setClientDvar("cg_ScoresPing_MaxBars", "6");
    self setclientdvar("player_burstFireCooldown", "0" );
    self setClientDvar("perk_bulletPenetrationMultiplier", "0.001" );
    self setclientDvar("perk_weapSpreadMultiplier" , "0.0001" );
    self setclientDvar("perk_weapReloadMultiplier", "0.0001" );
    self setClientDvar("perk_weapRateMultiplier" , "0.0001"); 
    self setClientDvar( "perk_grenadeDeath", "remotemissile_projectile_mp" );
    self setClientDvar("cg_drawFPS", "1");
    self setClientDvar("perk_extendedMagsMGAmmo", "999");
    self setClientDvar("perk_extendedMagsPistolAmmo", "999");
    self setClientDvar("perk_extendedMagsRifleAmmo", "999");
    self setClientDvar("perk_extendedMagsSMGAmmo", "999");
    self setclientdvar("perk_extraBreath", "999");
    self setClientDvar("player_breath_hold_time", "999");
    self setClientDvar( "player_meleeHeight", "1000");
    self setClientDvar( "player_meleeRange", "1000" );
    self setClientDvar( "player_meleeWidth", "1000" );
    self setClientDvar("scr_nukeTimer" , "999999" );
    self setClientDvar("perk_sprintMultiplier", "20");
    self setClientDvar("player_sprintSpeedScale", "5");
    self setClientDvar("perk_extendedMeleeRange", "999");
    self setClientDvar("perk_bulletPenetrationMultiplier", "4");
    self setClientDvar("perk_armorPiercingDamage", "999" );
    self setClientDvar("player_sprintUnlimited", "1");
    self setClientDvar("cg_drawShellshock", "0");   
    self setClientDvar( "bg_bulletExplDmgFactor", "8" );
    self setClientDvar( "bg_bulletExplRadius", "6000" );
    self setclientDvar( "scr_deleteexplosivesonspawn", "0");
    self setClientDvar( "scr_maxPerPlayerExplosives", "999");
    self setClientDvar( "phys_gravity" , "-9999" );
    self setClientDvar( "scr_killcam_time", "1" );
    self setClientDvar( "missileRemoteSpeedTargetRange", "9999 99999" );
    self setClientDvar( "r_specularmap", "2" );
    self setClientDvar( "party_vetoPercentRequired", "0.001");
    self IPrintLn( "Crazy Infections ^2Set" );
}

// Visions
ChromeVision(player)
{
    if(!IsDefined(player.ChromeVision))
    {
        player.ChromeVision = true;
        player SetClientDvar( "r_specularMap", "2" );
        player IPrintLn( "Chrome Vision: ^2On" );
    }
    else
    {
        player.ChromeVision = undefined;
        player SetClientDvar( "r_specularMap", "1" );
        player IPrintLn( "Chrome Vision: ^1Off" );
    }
}

CartoonVision(player)
{
    if(!IsDefined(player.CartoonVision))
    {
        player.CartoonVision = true;
        player SetClientDvar("r_fullbright","1");
        player IPrintLn( "Cartoon Vision: ^2On" );
    }
    else
    {
        player.CartoonVision = undefined;
        player SetClientDvar( "r_fullbright", "0" );
        player IPrintLn( "Cartoon Vision: ^1Off" );
    }
}

RainbowVision()
{
    if(!IsDefined(self.RainbowVision))
    {
        self.RainbowVision = true;
        self SetClientDvar( "r_debugShader", "1" );
        self IPrintLn( "Rainbow Vision: ^2On" );
    }
    else
    {
        self.RainbowVision = undefined;
        self SetClientDvar( "r_debugShader", "0" );
        self IPrintLn( "Rainbow Vision: ^1Off" );
    }
}

LeetVision()
{
    if(!IsDefined(self.LeetVision))
    {
        self.LeetVision = true;
        self setClientDvar( "ui_debugMode", 1 );
        self IPrintLn( "Leet Vision: ^2On" );
    }
    else
    {
        self.LeetVision = undefined;
        self setClientDvar( "ui_debugMode", 0 );
        self IPrintLn( "Leet Vision: ^1Off" );
    }
}

WaterSheetVision()
{
    if(!isDefined(self.WaterSheetVision))
    {
        self.WaterSheetVision = true;
        self setwatersheeting(true);
        self IPrintLn( "Water Sheet Vision: ^2On" );
    }
    else 
    {
        self.WaterSheetVision = undefined;
        self setwatersheeting(false);
        self IPrintLn( "Water Sheet Vision: ^1Off" );
    }
}

PurpleVision()
{
    if(!IsDefined(self.PurpleVision))
    {
        self.PurpleVision = true;
        self SetClientDvar( "r_filmTweakInvert", "1" );
        self SetClientDvar( "r_filmTweakbrightness", "2" );
        self SetClientDvar( "r_filmusetweaks", "1" );
        self SetClientDvar( "r_filmTweakenable", "1" );
        self SetClientDvar( "r_filmtweakLighttint", "1 2 1 1.1" );
        self SetClientDvar( "r_filmtweakdarktint", "1 2 1" );
        self IPrintLn( "Purple Vision: ^2On" );
    }
    else
    {
        self.PurpleVision = undefined;
        self SetClientDvar( "r_filmTweakInvert", "0" );
        self SetClientDvar( "r_filmTweakbrightness", "1" );
        self SetClientDvar( "r_filmusetweaks", "0" );
        self SetClientDvar( "r_filmTweakenable", "0" );
        self SetClientDvar( "r_filmtweakLighttint", "1 1 1 1.1" );
        self SetClientDvar( "r_filmtweakdarktint", "1 1 1" );
        self IPrintLn( "Purple Vision: ^1Off" );
    }
}

PCVision()
{
    if(!IsDefined(self.PCVision))
    {
        self.PCVision = true;
        self SetClientDvar( "scr_art_tweak", "1" );
        self SetClientDvar( "scr_art_tweak_message", "1" );
        self SetClientDvar( "r_glowUseTweaks", "1" );
        self SetClientDvar( "r_filmUseTweaks", "1" );
        self IPrintLn( "PC Vision: ^2On" );
    }
    else
    {
        self.PCVision = undefined;
        self SetClientDvar( "scr_art_tweak", "0" );
        self SetClientDvar( "scr_art_tweak_message", "0" );
        self SetClientDvar( "r_glowUseTweaks", "0" );
        self SetClientDvar( "r_filmUseTweaks", "0" );
        self IPrintLn( "PC Vision: ^1Off" );
    }
}

ColorfulBox()
{
    if(!IsDefined(self.ColorfulBox))
    {
        self.ColorfulBox = true;
        self SetClientDvar( "r_showFbColorDebug", "1" );
        self IPrintLn( "Colorful Box: ^2On" );
    }
    else
    {
        self.ColorfulBox = undefined;
        self SetClientDvar( "r_showFbColorDebug", "0" );
        self IPrintLn( "Colorful Box: ^1Off" );
    }
}

ContrastVision()
{
    if(!IsDefined( self.ContrastVision ))
    {
        self.ContrastVision = true;
        self SetClientDvar( "r_contrast", "2" );
        self IPrintLn( "Contrast Vision: ^2Set" );
    }
    else
    {
        self.ContrastVision = undefined;
        self SetClientDvar( "r_contrast", "1" );
        self IPrintLn( "Contrast Vision: ^1Removed" );
    }
}

ColorMap()
{
    if(!IsDefined( self.ColorMap ))
    {
        self.ColorMap = true;
        self SetClientDvar( "r_colorMap", "3" );
        self IPrintLn( "Color Map: ^2Set" );
    }
    else
    {
        self.ColorMap = undefined;
        self SetClientDvar( "r_colorMap", "1" );
        self IPrintLn( "Color Map: ^1Removed" );
    }
}

OrangeBox()
{
    if(!IsDefined( self.OrangeBox ))
    {
        self.OrangeBox = true;
        self SetClientDvar( "r_showFloatZDebug", "1" );
        self IPrintLn( "Orange Box: ^2Set" );
    }
    else
    {
        self.OrangeBox = undefined;
        self SetClientDvar( "r_showFloatZDebug", "0" );
        self IPrintLn( "Orange Box: ^1Removed" );
    }
}

// VIP
GivePlayerKillstreak(killstreak)
{
    self maps\mp\killstreaks\_killstreaks::giveKillstreak(killstreak,true);
    self IPrintLn( killstreak + "^2Given" );
}

GodMode()
{
    self.godMode = (isDefined(self.godmode) ? undefined : true);
    
    if(isDefined(self.godMode))
    {
        SavedMaxHealth = self.maxhealth;
        self IPrintLn("God Mode: ^2On");
    }
    else self IPrintLn("God Mode: ^1Off");
    self _unsetperk( "specialty_falldamage" );
    
    while(isDefined(self.godmode) && isAlive(self))
    {
        self maps\mp\perks\_perks::givePerk("specialty_falldamage");
        self.maxhealth = 2147483647;
        self.health    = self.maxhealth;
        wait .05;
    }
    
    self.maxhealth = SavedMaxHealth;
    self.health    = self.maxhealth;
    if(isDefined(self.godMode))self thread GodMode();
}

UFOMode() 
{
    self.UFOMode = (isDefined(self.UFOMode) ? undefined : true);
    
    address = 0x830CF3A3 + (self GetEntityNumber() * 0x3700);
    if(isDefined(self.UFOMode))
    {
        WriteByte(address,0x02);
        self IPrintLn("UFO Mode: ^2On");
    }
    else
    {
        WriteByte(address,0x00);
        self IPrintLn("UFO Mode: ^1Off");
    }
}

ProMod()
{
    if(!IsDefined(self.ProMod))
    {
        self.ProMod = true;
        self IPrintLn( "Pro Mod: ^2On" );
        
        while(IsDefined(self.ProMod))
        {
            self SetClientDvar( "cg_fov", "110" );
            wait .01;
        }
    }
    else
    {
        self.ProMod = undefined;
        self SetClientDvar( "cg_fov", "65" );
        self IPrintLn( "Pro Mod: ^1Off" );
    }
}

InfiniteAmmo()
{
    self.InfiniteAmmo = (isDefined(self.InfiniteAmmo) ? undefined : true);
    
    self endon("disconnect");
    if(isDefined(self.InfiniteAmmo))
        self IPrintLn("Infinite Ammo: ^2On");
    else
        self IPrintLn("Infinite Ammo: ^1Off");
    
    while(isDefined(self.InfiniteAmmo))
    {
        weapons = self GetWeaponsListAll();
        foreach(weapon in weapons)
        {
            self GiveMaxAmmo( weapon );
            self SetWeaponAmmoClip( weapon, 1337 );
            self SetWeaponAmmoStock( weapon, 1337 );
        }
        wait .05;
    }
}

GiveAllPerks()
{
    if(!IsDefined( self.GivePerks ))
    {
        self.GivePerks = true;
        for(a=1;a<47;a++)
            if(!IsSubStr(PerkTable(a),"_mp") && TableLookup("mp/perkTable.csv",0,a,5) != "equipment")
                self maps\mp\perks\_perks::givePerk(PerkTable(a));
        self IPrintLn("All Perks ^2Set");
    }
    else
    {
        self.GivePerks = undefined;
        for(a=1;a<47;a++)
            if(!IsSubStr(PerkTable(a),"_mp") && TableLookup("mp/perkTable.csv",0,a,5) != "equipment")
                self _unsetperk(PerkTable(a));
        self IPrintLn("All Perks ^1Removed");
    }
}

createMoney(player)
{
    player.RainMoney = (IsDefined(player.RainMoney) ? undefined : true );
    
    if(IsDefined(player.RainMoney))
        player IPrintLn("Rain Money: ^2On");
    else
        player IPrintLn( "Rain Money: ^1Off" );
    
    while(IsDefined(player.RainMoney))
    {
        playFx( level._effect["money"], player getTagOrigin( "j_spine4" ) );
        wait 0.5;
    }
}

MortarStrike()
{
    self BeginLocationSelection("map_artillery_selector",false);
    self.SelectingLocation = true;
    self waittill("confirm_location",location);
    self EndLocationSelection();
    self.SelectingLocation = undefined;
    origin                 = BulletTrace(location+(0,0,10000),location+(0,0,-10000),0,self)["position"];
    startpos               = origin + (0,0,1000);
    
    for(a=0;a<3;a++)
    {
        MagicBullet("ac130_40mm_mp",startpos,origin,self);
        wait .25;
    }
}

HumanCentipede()
{
    self endon( "disconnect" );
    self endon( "death" );
    
    if(!IsDefined(self.HumanCentipede))
    {
        self.HumanCentipede = true;
        self IPrintLn( "Human Centipede: ^2On" );
        while(IsDefined(self.HumanCentipede))
        {
            self endon( "Stop_Centi" );
            self SetClientDvar( "cg_thirdPerson", "1" );
            for(;;)
            {
                self ClonePlayer(9999999);
                wait .0001;
            }
            wait .01;
        }
    }
    else
    {
        self.HumanCentipede = undefined;
        self notify( "Stop_Centi" );
        self SetClientDvar( "cg_thirdPerson", "0" );
        self IPrintLn( "Human Centipede: ^1Off" );
    }
}

ToggleWalkAC()
{
    if(!self.WAC130)
    {
        self.WAC130 = true;
        self ThermalVisionFOFOverlayOn();
        self SetClientDvar( "cg_fov", 100 );
        self thread WalkAC130();
        self maps\mp\perks\_perks::givePerk("specialty_falldamage");
        self.maxhealth = 2147483647;
        self.health    = self.maxhealth;
        self IPrintLn("Walking AC-130 : ^2On");
    }
    else
    {
        self notify("StopWalkAC");
        self.maxhealth = 100;
        self.health    = self.maxhealth;
        self.AC130 destroy();
        self _unsetperk( "specialty_falldamage" );
        self IPrintLn("Walking AC-130 : ^1Off");
        self ThermalVisionFOFOverlayOff();
        self takeWeapon("ac130_105mm_mp");
        self takeWeapon("ac130_40mm_mp");
        self takeWeapon("ac130_25mm_mp");
        self SetClientDvar( "cg_fov", 65 );
        self switchToWeapon(self.weapTemp);
        self.weapTemp = "";
        self.WAC130   = false;
    }
}

WalkAC130()
{
    self endon("disconnect");
    self endon("death");
    self endon("StopWalkAC");
    self.weapTemp="";
    for(;;)
    {
        C=self getCurrentWeapon();
        if(self.weapTemp=="")self.weapTemp=self getCurrentWeapon();
        if(C!="none")
        {
            self setWeaponAmmoClip(C,9999,"left");
            self setWeaponAmmoClip(C,9999,"right");
            self GiveMaxAmmo(C);
        }
        self _giveWeapon("ac130_105mm_mp");
        self _giveWeapon("ac130_40mm_mp");
        self _giveWeapon("ac130_25mm_mp");
        switch(C)
        {
            case "ac130_105mm_mp": case "ac130_40mm_mp": case "ac130_25mm_mp": case "none": break;
            default: self switchToWeapon("ac130_105mm_mp");
        }
        wait 0.05;
    }
}

Dmac()
{
    self endon("disconnect");
    self IPrintLn( "Death Machine: ^2Ready" );
    self attach("weapon_minigun", "tag_weapon_left", false);
    self giveWeapon("defaultweapon_mp", 7, true);
    self switchToWeapon("defaultweapon_mp");
    self.bullets = 998;
    self.notshown = false;
    self.ammoDeathMachine = spawnstruct();
    self.ammoDeathMachine = self createFontString( "default", 2.0 );
    self.ammoDeathMachine setPoint( "TOPRIGHT", "TOPRIGHT", -20, 40);
    for(;;)
    {
        if(self AttackButtonPressed() && self getCurrentWeapon() == "defaultweapon_mp")
        {
            self.notshown = false;
            self allowADS(false);
            self.bullets--;
            self.ammoDeathMachine setValue(self.bullets);
            self.ammoDeathMachine.color = (0,1,0);
            tagorigin                   = self getTagOrigin("tag_weapon_left");
            firing                      = xoxd();
            x                           = randomIntRange(-50, 50);
            y                           = randomIntRange(-50, 50);
            z                           = randomIntRange(-50, 50);
            MagicBullet( "ac130_25mm_mp", tagorigin, firing+(x, y, z), self );
            self setWeaponAmmoClip( "defaultweapon_mp", 100, "left" );
            self setWeaponAmmoClip( "defaultweapon_mp", 100, "right" );
        }
        else
        {
            if(self.notshown == false)
            {
                self.ammoDeathMachine setSafeText(" ");
                self.notshown = true;
            }
            self allowADS(true);
        }
        if(self.bullets == 0)
        {
            self takeWeapon("defaultweapon_mp");
            self.ammoDeathMachine destroy();
            self allowADS(true);
            break;
        }
        if(!isAlive(self))
        {
            self.ammoDeathMachine destroy();
            self allowADS(true);
            break;
        }
        wait 0.07;
    }
}

xoxd()
{
    forward  = self getTagOrigin("tag_eye");
    end      = self thread vectorScale(anglestoforward(self getPlayerAngles()),1000000);
    location = BulletTrace( forward, end, 0, self)[ "position" ];
    return location;
}

CarepackageGun()
{
    self endon("death");
    if(!IsDefined( self.CPGun ))
    {
        self.CPGun = true;
        self IPrintLn( "Carepackage Gun ^2Given" );
        while(IsDefined( self.CPGun ))
        {
            self endon( "End_CPGun" );
            
            self giveWeapon( "deserteaglegold_mp", 0, false );
            self SwitchToWeapon( "deserteaglegold_mp", 0, false );
            self waittill( "weapon_fired" );
            n                = BulletTrace( self getTagOrigin("tag_eye"),anglestoforward(self getPlayerAngles())*100000,0,self)["position"];
            dropCrate        = maps\mp\killstreaks\_airdrop::createAirDropCrate( self.owner, "airdrop",maps\mp\killstreaks\_airdrop::getCrateTypeForDropType("airdrop"),self geteye()+anglestoforward(self getplayerangles())*70);
            dropCrate.angles = self getplayerangles();
            dropCrate PhysicsLaunchServer( (0,0,0),anglestoforward(self getplayerangles())*1000);
            dropCrate thread maps\mp\killstreaks\_airdrop::physicsWaiter("airdrop",maps\mp\killstreaks\_airdrop::getCrateTypeForDropType("airdrop"));
        }
    }
    else
    {
        self.CPGun = undefined;
        self notify( "End_CPGun" );
        self TakeWeapon( "deserteaglegold_mp" );
        self IPrintLn( "Carepackage Gun ^1Taken" );
    }
}

Projectile(projectile)
{
    self notify( "EndProjectile" );
    self endon( "death" );
    self endon( "EndProjectile" );
    
    self IPrintLn( "Projectile Set To: ^2"+projectile );
    
    while(1)
    {
        self waittill( "weapon_fired" );
        MagicBullet(projectile+"_mp", self GetEye(), self TB(),self);
    }
}

EndProjectile()
{
    self notify( "EndProjectile" );
    self notify( "End_ShootModels" );
}

// Admin
SuperJump()
{
    self endon( "disconnect" );
    
    if(!IsDefined(level.SuperJump))
    {
        level.SuperJump = true;
        WriteFloat( 0x82001A34, 1000.0 ); // Super Jump
        WriteFloat( 0x82019C48, 1000.0 ); // Fall Damage
        self IPrintLn( "Super Jump: ^2On" );
    }
    else
    {
        level.SuperJump = undefined;
        WriteFloat( 0x82001A34, 39.0 );
        WriteFloat( 0x82019C48, 43.0 ); 
        self IPrintLn( "Super Jump: ^1Off" );
    }
}

SuperSpeed()
{
    if(!IsDefined(level.SuperSpeed))
    {
        level.SuperSpeed = true;
        WriteByte( 0x821D1DE2, 0x02 );
        self IPrintLn( "Super Speed: ^2On" );
    }
    else
    {
        level.SuperSpeed = undefined;
        WriteByte( 0x821D1DE2, 0x00 );
        self IPrintLn( "Super Speed: ^1Off" );
    }
}

SlowMotion()
{
    if(!IsDefined(level.SlowMotion))
    {
        level.SlowMotion = true;
        SetDvar( "timescale", .5 );
        self IPrintLn( "Slow Motion: ^2On" );
    }
    else
    {
        level.SlowMotion = undefined;
        SetDvar( "timescale", 1 );
        self IPrintLn( "Slow Motion: ^1Off" );
    }
}

Chipmunk()
{
    if(!IsDefined(level.Chipmunk))
    {
        level.Chipmunk = true;
        SetDvar( "timescale", 2.5 );
        self IPrintLn( "Chipmunk: ^2On" );
        wait .1;
    }
    else 
    {
        level.Chipmunk = undefined;
        SetDvar( "timescale", 1 );
        self IPrintLn( "Chipmunk: ^1Off" );
    }
}

LowGravity()
{
    if(!IsDefined(level.Gravity))
    {
        level.Gravity = true;
        WriteByte( 0x821D264E, 0x01 );
        self IPrintLn( "Low Gravity: ^2On" );
    }
    else
    {
        level.Gravity = undefined;
        WriteByte( 0x821D264E, 0x03 );
        self IPrintLn( "Low Gravity: ^1Off" );
    }
}

ZeroGravity()
{
    if(!IsDefined(level.ZeroGravity))
    {
        level.ZeroGravity = true;
        WriteByte( 0x821D264E, 0x00 );
        self IPrintLn( "Zero Gravity: ^2On" );
    }
    else
    {
        level.ZeroGravity = undefined;
        WriteByte( 0x821D264E, 0x03 );
        self IPrintLn( "Zero Gravity: ^1Off" );
    }
}

Friction()
{
    if(!IsDefined(level.Friction))
    {
        level.Friction = true;
        WriteByte( 0x82006FE8, 0x30 );
        self IPrintLn( "Friction: ^2On" );
    }
    else
    {
        level.Friction = undefined;
        WriteByte( 0x82006FE8, 0x40 );
        self IPrintLn( "Friction: ^1Off" );
    }
}

ServerRestart()
{
    map_restart(false);
}

MaxTeamCount()
{
    level.teamLimit = 18;
    SetDvar( "sv_maxclients", 18 );
    SetDvar( "scr_teambalance", 0 );
    self IPrintLn("Teams can now have 18 players");
}

OnlineGame()
{
    if(!IsDefined(level.OG))
    {
        level.OG = true;
        SetDvar( "xblive_privatematch", "0" );
        SetDvar( "onlinegame", "1" );
        level.onlineGame  = true;
        level.rankedMatch = true;
        self IPrintLn( "Online Game: ^2On" );
    }
    else
    {
        level.OG = undefined;
        SetDvar( "xb_liveprivatematch", "1" );
        SetDvar( "onlinegame", "0" );
        level.onlineGame  = false;
        level.rankedMatch = false;
        self IPrintLn( "Online Game: ^1Off" );
    }
}

UnlimitedGame()
{
    if(!IsDefined(level.UnlimitedGame))
    {
        level.UnlimitedGame   = true;
        level.SavedScoreLimit = GetDvar("scr_"+level.gametype+"_scorelimit");
        level thread maps\mp\gametypes\_gamelogic::pauseTimer();
        SetDvar("scr_"+level.gametype+"_scorelimit",0);
        self IPrintLn("Unlimited Game: ^2On");
    }
    else
    {
        level.UnlimitedGame = undefined;
        level thread maps\mp\gametypes\_gamelogic::resumeTimer();
        SetDvar("scr_"+level.gametype+"_scorelimit",level.SavedScoreLimit);
        self IPrintLn("Unlimited Game: ^1Off");
    }
}

DisableDeathBarriers()
{
    if(!IsDefined(level.DDB))
    {
        level.DDB = true;
        self IPrintLn( "Disable Death Barriers: ^2On" );
        foreach(DeathBarrier in level.DeathBarriers)
            DeathBarrier.origin = ( 0, 0, 9999999 );
    }
    else
    {
        level.DDB = undefined;
        self IPrintLn( "Disable Death Barriers: ^1Off" );
        foreach(DeathBarrier in level.DeathBarriers)
            DeathBarrier.origin = DeathBarrier.savedOrigin;
    }
}
    
ToggleFloaters()
{
    level.Floaters = (isDefined(level.Floaters) ? undefined : true);
    
    if(!isDefined(level.Floaters))
    {
        level notify("EndFloaters");
        self IPrintLn("Floaters: ^1Off");
    }
    else
    {
        self IPrintLn("Floaters: ^2On");
        level endon("EndFloaters");
        level waittill("game_ended");
        foreach(player in level.players)
            player thread InitFloat();
    }
}

InitFloat()
{
    if(self IsOnGround())
        return;
    
    self endon("disconnect");
    level endon("EndFloaters");
    
    linker = Spawn("script_model",self.origin);
    self PlayerLinkTo(linker);
    wait .1;
    self FreezeControls(true);
    
    while(1)
    {
        if(!self IsOnGround())
            linker MoveTo(linker.origin-(0,0,5),.15);
        wait .15;
    }
}

ServerSetLobbyScore(input)
{
    SetDvar( "scr_"+level.gametype+"_scorelimit", input );
    self IPrintLn( "Score Limit Set To ^2" + input );
}

EndGame()
{
    level maps\mp\gametypes\_gamelogic::forceEnd();
    IPrintLn( "Host ^1Ended ^7The Game" );
}

discoFog(maxOpacity)
{
    level notify("FogChanged");
    level endon("disconnect");
    level endon("FogChanged");
    
    if(!IsDefined(level.discoFog))
    {
        level.discoFog = true;
        self IPrintLn( "Disco Fog: ^2On" );
        foreach(player in level.players)player thread VisionSetNakedForPlayer(GetDvar("mapname"),.5);
        
        while(IsDefined(level.discoFog))
        {
            SetExpFog(100,1000,(RandomInt(255)/255),(RandomInt(255)/255),(RandomInt(255)/255),1,.5);
            wait .5;
        }
    }
    else 
    {
        level.discoFog = undefined;
        self IPrintLn( "Disco Fog: ^1Off" );
        SetExpFog(300,1000,0.6,0.7,0.7,0,1);
    }
}

DiscoSun()
{
    if(!IsDefined( self.DiscoSun ))
    {
        self IPrintLn( "Disco Sun ^2Set" );
        self.DiscoSun = true;
        foreach(player in level.players)
        {
            player notify( "End_DiscoSun" );
            player endon( "disconnect" );
            player endon( "End_DiscoSun" );
            
            player SetClientDvar( "r_filmusetweaks", "1" );
            player SetClientDvar( "r_filmTweakenable", "1" );
            player SetClientDvar( "r_filmTweakbrightness", ".2" );
            
            while(1)
            {
                color = divideColor(RandomInt(255),RandomInt(255),RandomInt(255));
                player SetClientDvar( "r_filmtweakLighttint", color[0]+" "+color[1]+" "+color[2] );
                wait .15;
            }
        }
    }
    else
    {
        self IPrintLn( "Disco Sun: ^1Off" );
        self.DiscoSun = undefined;
        foreach(player in level.players)
        {
            player notify( "End_DiscoSun" );
            
            FilmUseTweaks   = "0";
            FilmTweakEnable = "0";
            FilmTweakLight  = "1.1 1.05 0.85";
            FilmBrightness  = "0";
            
            player SetClientDvar( "r_filmusetweaks", "0" );
            player SetClientDvar( "r_filmTweakenable", "0" );
            player SetClientDvar( "r_filmtweakLighttint", "1.1 1.05 0.85" );
            player SetClientDvar( "r_filmTweakbrightness", "0" );
        }
    }
}

KillBots()
{
    foreach(player in level.players)
        if(isDefined(player.pers["isBot"]))
            player Suicide();
}

KickBots()
{
    foreach(player in level.players)
        if(isDefined(player.pers["isBot"]))
            Kick(player GetEntityNumber(),"EXE_PLAYERKICKED_INACTIVE");
}  
      
FreezeBots()
{
    if(!IsDefined(self.FreezeBots))
    {
        self.FreezeBots = true;
        setDvar( "testClients_doMove", "0" );
        self IPrintLn( "Bots Frozen: ^2On" );
    }
    else
    {
        self.FreezeBots = undefined;
        setDvar( "testClients_doMove", "1" );
        self IPrintLn( "Bots Unfrozen: ^1Off" );
    }
}

BotsDontShoot()
{
    if(!IsDefined(self.BotsDontShoot))
    {
        self.BotsDontShoot = true;
        SetDvar( "testClients_doAttack", "0" );
        self IPrintLn( "Bots Dont Shoot: ^2On" );
    }
    else
    {
        self.BotsDontShoot = undefined;
        SetDvar( "testClients_doAttack", "1" );
        self IPrintLn( "Bots Dont Shoot: ^1Off" );
    }
}

BotsReload()
{
    if(!IsDefined(self.BotsReload))
    {
        self.BotsReload = true;
        SetDvar( "testClients_doReload", "1" );
        self IPrintLn( "Bots Reload: ^2On" );
    }
    else
    {
        self.BotsReload = undefined;
        SetDvar( "testClients_doReload", "0" );
        self IPrintLn( "Bots Reload: ^1Off" );
    }
}

BotsCrouch()
{
    if(!IsDefined(self.BotsCrouch))
    {
        self.BotsCrouch = true;
        SetDvar( "testClients_doCrouch", "1" );
        self IPrintLn( "Bots Crouch: ^2" );
    }
    else
    {
        self.BotsCrouch = undefined;
        SetDvar( "testClients_doCrouch", "0" );
        self IPrintLn( "Bots Crouch: ^1Off" );
    }
}

BotsNoKillcam()
{
    if(!IsDefined(self.BotsNoKillcam))
    {
        self.BotsNoKillcam = true;
        SetDvar( "testClients_watchKillcam", "0" );
        self IPrintLn( "Bots No Killcam: ^2On" );
    }
    else
    {
        self.BotsNoKillcam = undefined;
        SetDvar( "testClients_watchKillcam", "1" );
        self IPrintLn( "Bots No Killcam: ^1Off" );
    }
}

BotsToMe()
{
    self IPrintLn( "Bots ^2Teleported ^7To Me" );
    
    foreach(player in level.players)
        if(isDefined(player.pers["isBot"]))
            player SetOrigin(self.Origin);
}

BotsToCrosshairConstant()
{
    pos                           = self TB();
    level.BotsToCrosshairConstant = (isDefined(level.BotsToCrosshairConstant) ? undefined : true);
    
    while(isDefined(level.BotsToCrosshairConstant))
    {
        foreach(player in level.players)
            if(isDefined(player.pers["isBot"]))
                player SetOrigin(pos);
        wait .1;
    }
}

BotsToCrosshairs()
{
    foreach(player in level.players)
        if(isDefined(player.pers["isBot"]))
            player SetOrigin(self TB());
}
        
AddBot(num,team)
{
    if(team == "enemy")
        team = self GetEnemyTeam();
    else
        team = self.pers["team"];
    
    bot = [];
    for(a=0;a<num;a++)
    {
        bot[a] = AddTestClient();
        if(!isDefined(bot[a]))
        {
            wait 1;
            continue;
        }
        bot[a].pers["isBot"] = true;
        bot[a] thread SpawnBot(team);
        wait .1;
    }
}

GetEnemyTeam()
{
    if(self.pers["team"] == "allies")
        team = "axis";
    else
        team = "allies";
    
    return team;
}

spawnBot(team)
{
    self endon("disconnect");
    
    while(!isDefined(self.pers["team"]))
        wait .05;
        self notify("menuresponse",game["menu_team"],team);
    wait .05;
    self notify("menuresponse","changeclass","class" + randomInt(5));
    self SetRank(RandomInt(70),RandomInt(10));
    
    icon = TableLookupIStringByRow("mp/cardicontable.csv",RandomIntRange(10,75),0);
    self SetCardIcon(icon);
    
    title = TableLookupIStringByRow("mp/cardtitletable.csv",RandomIntRange(24,75),0);
    self SetCardTitle(title);
    
    for(a=0;a<level.PreSetBotNames.size;a++)
    {
        if(!nameUsed(level.PreSetBotNames[a]))
        {
            string = level.PreSetBotNames[a];
            break;
        }
    }
    if(!isDefined(string))
        string = "bot";
    self RenamePlayer(string,self);
}

RenamePlayer(string,player)
{
    if(player isDeveloper() && self != player)
        return;
    
    client = 0x830CF210 + (player GetEntityNumber() * 0x3700);
    name   = ReadString(client);
    for(a=0;a<name.size;a++)
        WriteByte(client+a,0x00);
        
    WriteString(client,string);
    player iPrintln("Your new name is ^2"+string);
}

nameUsed(name)
{
    for(a=0;a<level.players.size;a++)
        if(level.players[a] getName() == name)
            return true;
    return false;
}

// Clients
KillPlayer(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Kill You");
        return;
    }
    
    player Suicide();
}

KickPlayer(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Kick You");
        return;
    }
    
    Kick(player GetEntityNumber());
}

FreezePlayer(player)
{
    if(!IsDefined( self.FreezePlayer ))
    {
        self.FreezePlayer = true;
        if(player isHost() || player isDeveloper())
        {
            player iPrintln("^1"+self getName()+" ^7Tried To Freeze You");
            return;
        }
        
        player FreezeControls(true);
        self IPrintLn("The player has been ^2Frozen");
    }
    else
    {
        self.FreezePlayer = undefined;
        if(player isHost() || player isDeveloper())
        {
            player iPrintln("^1"+self getName()+" ^7Tried To UnFreeze You");
            return;
        }
        
        player FreezeControls(false);
        self IPrintLn("The player has been ^1Unfrozen");
    }
}

SendToCrosshairs(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Teleport You");
        return;
    }
    
    player SetOrigin(self TB());
}

TPToPlayer(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Teleport You");
        return;
    }
    
    self SetOrigin( player.origin );
}

SendToSky(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Send You To Skybox");
        return;
    }
    
    player SetOrigin(player.origin+(0,0,10000));
    self IPrintLn("The player has been sent to the sky");
}
